<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-Files-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwadapter="urn:WebWorks-XSLT-Extension-Adapter"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwadapter wwimaging wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterPDFSplitFileType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:namespace-alias stylesheet-prefix="wwfiles" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-documentid" match="wwsplits:File" use="@documentID" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarIgnore1">
    <xsl:value-of select="wwprogress:Start(count($VarProjectGroups))" />
   </xsl:variable>
   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarIgnore2">
     <xsl:value-of select="wwprogress:Start(1)" />
    </xsl:variable>

    <!-- Load splits -->
    <!--             -->
    <xsl:for-each select="$GlobalInput[1]">
     <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitsType))[1]" />
     <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

     <!-- Process group input documents -->
     <!--                               -->
     <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterDependsType))" />
     <xsl:variable name="VarIgnore3">
      <xsl:value-of select="wwprogress:Start(count($VarFilesByType))" />
     </xsl:variable>
     <xsl:for-each select="$VarFilesByType">
      <xsl:variable name="VarFile" select="." />

      <xsl:variable name="VarIgnore4">
       <xsl:value-of select="wwprogress:Start(1)" />
      </xsl:variable>

      <!-- Get PDF path -->
      <!--              -->
      <xsl:for-each select="$VarSplits[1]">
       <xsl:variable name="VarPDFSplitFile" select="key('wwsplits-files-by-documentid', $VarFile/@documentID)[@type = $ParameterPDFSplitFileType][1]" />
       <xsl:for-each select="$VarPDFSplitFile">
        <!-- Up-to-date? -->
        <!--             -->
        <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPDFSplitFile/@path, '', $VarFile/@groupID, $VarFile/@documentID, $GlobalActionChecksum)" />
        <xsl:if test="not($VarUpToDate)">
         <!-- Generate PDF -->
         <!--              -->
         <xsl:variable name="VarIgnore5">
          <xsl:value-of select="wwimaging:PostScriptToPDF($VarFile/@path, wwprojext:GetFormatSetting('pdf-job-settings', 'default'), $VarPDFSplitFile/@path)" />
         </xsl:variable>
        </xsl:if>

        <!-- Track PDF file -->
        <!--                -->
        <wwfiles:File path="{$VarPDFSplitFile/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPDFSplitFile/@path)}" projectchecksum="" groupID="{$VarPDFSplitFile/@groupID}" documentID="{$VarPDFSplitFile/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
         <wwfiles:Depends path="{$VarFile/@path}" checksum="{$VarFile/@checksum}" groupID="{$VarFile/@groupID}" documentID="{$VarFile/@documentID}" />
        </wwfiles:File>

       </xsl:for-each>
      </xsl:for-each>

      <xsl:variable name="VarIgnore6">
       <xsl:value-of select="wwprogress:End()" />
      </xsl:variable>
     </xsl:for-each>

     <xsl:variable name="VarIgnore7">
      <xsl:value-of select="wwprogress:End()" />
     </xsl:variable>
    </xsl:for-each>

    <xsl:variable name="VarIgnore8">
     <xsl:value-of select="wwprogress:End()" />
    </xsl:variable>
   </xsl:for-each>

   <xsl:variable name="VarIgnore9">
    <xsl:value-of select="wwprogress:End()" />
   </xsl:variable>

  </wwfiles:Files>
 </xsl:template>
</xsl:stylesheet>
